// Copyright 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is autogenerated by:
//     mojo/public/tools/bindings/mojom_bindings_generator.py
// For:
//     device/serial/serial_serialization.mojom
//

package org.chromium.mojom.device.serial;

public final class SerializedConnection extends org.chromium.mojo.bindings.Struct {

    private static final int STRUCT_SIZE = 56;
    private static final org.chromium.mojo.bindings.DataHeader[] VERSION_ARRAY = new org.chromium.mojo.bindings.DataHeader[] {new org.chromium.mojo.bindings.DataHeader(56, 0)};
    private static final org.chromium.mojo.bindings.DataHeader DEFAULT_STRUCT_INFO = VERSION_ARRAY[0];

    public ConnectionState state;
    public int queuedReceiveError;
    public byte[] queuedReceiveData;
    public Connection connection;
    public SerializedDataSender sender;
    public SerializedDataReceiver receiver;

    private SerializedConnection(int version) {
        super(STRUCT_SIZE, version);
        queuedReceiveError = (int) ReceiveError.NONE;
    }

    public SerializedConnection() {
        this(0);
    }

    public static SerializedConnection deserialize(org.chromium.mojo.bindings.Message message) {
        return decode(new org.chromium.mojo.bindings.Decoder(message));
    }

    @SuppressWarnings("unchecked")
    public static SerializedConnection decode(org.chromium.mojo.bindings.Decoder decoder0) {
        if (decoder0 == null) {
            return null;
        }
        org.chromium.mojo.bindings.DataHeader mainDataHeader = decoder0.readAndValidateDataHeader(VERSION_ARRAY);
        SerializedConnection result = new SerializedConnection(mainDataHeader.elementsOrVersion);
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(8, false);
            result.state = ConnectionState.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.queuedReceiveError = decoder0.readInt(16);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.queuedReceiveData = decoder0.readBytes(24, org.chromium.mojo.bindings.BindingsHelper.ARRAY_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            result.connection = decoder0.readServiceInterface(32, false, Connection.MANAGER);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(40, false);
            result.sender = SerializedDataSender.decode(decoder1);
        }
        if (mainDataHeader.elementsOrVersion >= 0) {
            org.chromium.mojo.bindings.Decoder decoder1 = decoder0.readPointer(48, false);
            result.receiver = SerializedDataReceiver.decode(decoder1);
        }
        return result;
    }

    @SuppressWarnings("unchecked")
    @Override
    protected final void encode(org.chromium.mojo.bindings.Encoder encoder) {
        org.chromium.mojo.bindings.Encoder encoder0 = encoder.getEncoderAtDataOffset(DEFAULT_STRUCT_INFO);
        encoder0.encode(state, 8, false);
        encoder0.encode(queuedReceiveError, 16);
        encoder0.encode(queuedReceiveData, 24, org.chromium.mojo.bindings.BindingsHelper.ARRAY_NULLABLE, org.chromium.mojo.bindings.BindingsHelper.UNSPECIFIED_ARRAY_LENGTH);
        encoder0.encode(connection, 32, false, Connection.MANAGER);
        encoder0.encode(sender, 40, false);
        encoder0.encode(receiver, 48, false);
    }

    /**
     * @see Object#equals(Object)
     */
    @Override
    public boolean equals(Object object) {
        if (object == this)
            return true;
        if (object == null)
            return false;
        if (getClass() != object.getClass())
            return false;
        SerializedConnection other = (SerializedConnection) object;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.state, other.state))
            return false;
        if (this.queuedReceiveError != other.queuedReceiveError)
            return false;
        if (!java.util.Arrays.equals(this.queuedReceiveData, other.queuedReceiveData))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.connection, other.connection))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.sender, other.sender))
            return false;
        if (!org.chromium.mojo.bindings.BindingsHelper.equals(this.receiver, other.receiver))
            return false;
        return true;
    }

    /**
     * @see Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = prime + getClass().hashCode();
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(state);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(queuedReceiveError);
        result = prime * result + java.util.Arrays.hashCode(queuedReceiveData);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(connection);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(sender);
        result = prime * result + org.chromium.mojo.bindings.BindingsHelper.hashCode(receiver);
        return result;
    }
}

